%------------------------------------------------------------------------------
% File     : NUM637^2 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Number Theory
% Problem  : Landau theorem 3
% Version  : Especial.
% English  :

% Refs     : [Lan30] Landau (1930), Grundlagen der Analysis
%          : [vBJ79] van Benthem Jutting (1979), Checking Landau's "Grundla
%          : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [TPTP]
% Names    : satz3 [Lan30]

% Status   : Theorem
% Rating   : 0.14 v7.4.0, 0.22 v7.2.0, 0.12 v7.0.0, 0.29 v6.4.0, 0.33 v6.3.0, 0.20 v6.2.0, 0.14 v5.5.0, 0.33 v5.4.0, 0.40 v5.3.0, 0.60 v5.2.0, 0.40 v5.1.0, 0.60 v4.1.0, 0.33 v4.0.1, 0.67 v3.7.0
% Syntax   : Number of formulae    :    6 (   0 unit;   2 type;   0 defn)
%            Number of atoms       :   28 (   5 equality;  15 variable)
%            Maximal formula depth :    8 (   5 average)
%            Number of connectives :   16 (   2   ~;   0   |;   1   &;   9   @)
%                                         (   0 <=>;   4  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    2 (   2   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    4 (   2   :;   0   =)
%            Number of variables   :    8 (   0 sgn;   7   !;   1   ?;   0   ^)
%                                         (   8   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(one_type,type,(
    one: $i )).

thf(succ_type,type,(
    succ: $i > $i )).

thf(one_is_first,axiom,(
    ! [X: $i] :
      ( ( succ @ X )
     != one ) )).

thf(succ_injective,axiom,(
    ! [X: $i,Y: $i] :
      ( ( ( succ @ X )
        = ( succ @ Y ) )
     => ( X = Y ) ) )).

thf(induction,axiom,(
    ! [M: $i > $o] :
      ( ( ( M @ one )
        & ! [X: $i] :
            ( ( M @ X )
           => ( M @ ( succ @ X ) ) ) )
     => ! [Y: $i] :
          ( M @ Y ) ) )).

thf(satz3,conjecture,(
    ! [X: $i] :
      ( ( X != one )
     => ? [U: $i] :
          ( X
          = ( succ @ U ) ) ) )).

%------------------------------------------------------------------------------
